unit LoadAsm;

interface

uses
  System.Drawing, System.Collections, System.ComponentModel,
  System.Windows.Forms, System.Data, LoadAsmImpl;

type
  TWinFormAssemblyLoaderGUI = class(System.Windows.Forms.Form)
  {$REGION 'Designer Managed Code'}
  strict private
    /// <summary>
    /// Required designer variable.
    /// </summary>
    Components: System.ComponentModel.Container;
                btnLoad: System.Windows.Forms.Button;
                btnUnload: System.Windows.Forms.Button;
                StatusBar1: System.Windows.Forms.StatusBar;
                btnMethod2: System.Windows.Forms.Button;
    /// <summary>
    /// Required method for Designer support - do not modify
    /// the contents of this method with the code editor.
    /// </summary>
    procedure InitializeComponent;
                procedure btnLoad_Click(sender: System.Object; e: System.EventArgs);
                procedure btnUnload_Click(sender: System.Object; e: System.EventArgs);
                procedure btnMethod2_Click(sender: System.Object; e: System.EventArgs);
  {$ENDREGION}
  strict protected
    /// <summary>
    /// Clean up any resources being used.
    /// </summary>
    AsmLoader: TAssemblyLoader;
    procedure Dispose(Disposing: Boolean); override;
  public
    constructor Create;
  end;

implementation
uses
  System.Reflection, System.Runtime.Serialization,
  System.Diagnostics, System.IO;

{$REGION 'Windows Form Designer generated code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWinFormAssemblyLoaderGUI.InitializeComponent;
begin
        Self.btnLoad := System.Windows.Forms.Button.Create;
        Self.btnUnload := System.Windows.Forms.Button.Create;
        Self.StatusBar1 := System.Windows.Forms.StatusBar.Create;
        Self.btnMethod2 := System.Windows.Forms.Button.Create;
        Self.SuspendLayout;
        // 
        // btnLoad
        // 
        Self.btnLoad.Location := System.Drawing.Point.Create(40, 16);
        Self.btnLoad.Name := 'btnLoad';
        Self.btnLoad.TabIndex := 0;
        Self.btnLoad.Text := 'Load';
        Include(Self.btnLoad.Click, Self.btnLoad_Click);
        // 
        // btnUnload
        // 
        Self.btnUnload.Location := System.Drawing.Point.Create(152, 16);
        Self.btnUnload.Name := 'btnUnload';
        Self.btnUnload.TabIndex := 1;
        Self.btnUnload.Text := 'Unload';
        Include(Self.btnUnload.Click, Self.btnUnload_Click);
        // 
        // StatusBar1
        // 
        Self.StatusBar1.Location := System.Drawing.Point.Create(0, 87);
        Self.StatusBar1.Name := 'StatusBar1';
        Self.StatusBar1.Size := System.Drawing.Size.Create(292, 22);
        Self.StatusBar1.TabIndex := 2;
        // 
        // btnMethod2
        // 
        Self.btnMethod2.Location := System.Drawing.Point.Create(64, 56);
        Self.btnMethod2.Name := 'btnMethod2';
        Self.btnMethod2.Size := System.Drawing.Size.Create(128, 23);
        Self.btnMethod2.TabIndex := 4;
        Self.btnMethod2.Text := 'Call Assembly Method';
        Include(Self.btnMethod2.Click, Self.btnMethod2_Click);
        // 
        // TWinFormAssemblyLoaderGUI
        // 
        Self.AutoScaleBaseSize := System.Drawing.Size.Create(5, 13);
        Self.ClientSize := System.Drawing.Size.Create(292, 109);
        Self.Controls.Add(Self.btnMethod2);
        Self.Controls.Add(Self.StatusBar1);
        Self.Controls.Add(Self.btnUnload);
        Self.Controls.Add(Self.btnLoad);
        Self.Name := 'TWinFormAssemblyLoaderGUI';
        Self.Text := 'Assembly Loader';
        Self.ResumeLayout(False);
end;
{$ENDREGION}

procedure TWinFormAssemblyLoaderGUI.Dispose(Disposing: Boolean);
begin
  if Disposing then
  begin
    if Components <> nil then
      Components.Dispose();
  end;
  inherited Dispose(Disposing);
end;

constructor TWinFormAssemblyLoaderGUI.Create;
begin
  inherited Create;
  //
  // Required for Windows Form Designer support
  //
  InitializeComponent;
  //
  // TODO: Add any constructor code after InitializeComponent call
  //
end;

procedure TWinFormAssemblyLoaderGUI.btnMethod2_Click(sender: System.Object; e: System.EventArgs);
begin
  if Assigned(AsmLoader) then
    begin
      // Calls a known method, in a known class, implemented in a known namespace	
      AsmLoader.Invoke('TestPkgClass.TClass1', 'SayItStatically');
    end else
    begin
      StatusBar1.Text := 'Assembly not loaded yet.';
    end;
end;

procedure TWinFormAssemblyLoaderGUI.btnUnload_Click(sender: System.Object; e: System.EventArgs);
begin
  Cursor := Cursors.WaitCursor;
  try
    try
      AsmLoader.Free;
      AsmLoader := nil;
    except
      on E: Exception do
        StatusBar1.Text := 'Failed due to: '+E.Message;
    end;
  finally
    Cursor := Cursors.Default;
  end;
end;

procedure TWinFormAssemblyLoaderGUI.btnLoad_Click(sender: System.Object; e: System.EventArgs);
var
 fi: FileInfo;
begin
  Cursor := Cursors.WaitCursor;
  try
    if not Assigned(AsmLoader) then
    try
      AsmLoader := TAssemblyLoader.Create;
      fi := FileInfo.Create(Assembly.GetExecutingAssembly.Location);
      AsmLoader.LoadAssembly(fi.DirectoryName+'\DynamicAssembly\TestPkg.dll');
// At this point, once the assembly is loaded, it can be updated, or deleted
// Subsequent invocations of this application will use the new assembly
// if it has been updated.
      StatusBar1.Text := 'Assembly loaded.';
    except
      StatusBar1.Text := 'Unable to load assembly.';
    end;
  finally
    Cursor := Cursors.Default;
  end;
end;

end.
